/*:ja
 * @target MZ
 * @plugindesc CoF用の大型ウィンドウ
 * @author 柊　七紀
 * @help
 * 他作品への無断使用はお控えください。
 * 個人の範囲で改変する分には問題ありません。
 *
 * 
 * @command openScene
 * @text 表示
 * @desc 変数ID:2の内容を全画面で表示。
 *
 */

(() => {

    const pluginName = document.currentScript.src.match(/^.*\/(.*).js$/)[1];

    // Plugin Command
    PluginManager.registerCommand(pluginName, "openScene", () => {
        SceneManager.push(Scene_bookMenu);
    });

    //ブックウィンドウを管理するシーン
    class Scene_bookMenu extends Scene_MenuBase {

        create() {
            super.create();

            //ウィンドウサイズの宣言
            const windowWidth = Graphics.boxWidth;
            const windowHeight = Graphics.boxHeight;
            //ウィンドウレイヤーを作成
            this.createWindowLayer();
            //サイズの決定（x座標,y座標,幅,高さ）
            const rect = new Rectangle(0, 0, windowWidth, windowHeight);
            //ウィンドゥの作成
            this._bookWindow = new Window_book(rect);
            //このウィンドウにフォーカスを当てる。
            this._bookWindow.activate();
            //決定・キャンセルでウィンドウを閉じる。
            this._bookWindow.setHandler("ok", this.popScene.bind(this));
            //this._bookWindow.setHandler("cancel", this.popScene.bind(this));
            //上記設定でウィンドウを作成
            this.addWindow(this._bookWindow);
        }
    }
    
    //ブックウィンドウクラス
    class Window_book extends Window_Selectable {

        initialize(rect) {
            //変数2番から文章を読み取り
            const book = $gameVariables.value(2);
            super.initialize(rect);
            //前の文字をクリア（おまじない）
            this.contents.clear();
            //文字出力
            this.drawTextEx(book, 0, 0, Graphics.boxWidth);
        }
    }

})();